; *****************************************************************************
; * NABU PC VGM Player v0.3 by GTAMP (c) 2026
; * MIT licensed
; * Code generated by the free version of Gemini 3 using the fast setting
; * Assembled with sjasmplus
; *****************************************************************************

    ORG $0100

; --- CP/M BDOS Constants ---
BDOS          EQU $0005
F_CONOUT      EQU 2
F_PRTSTR      EQU 9
F_OPEN        EQU 15
F_READ        EQU 20
F_SETDMA      EQU 26
F_SIZE        EQU 35           
F_DIRIO       EQU 6            
F_USER        EQU 32           
F_CURDRV      EQU 25           
F_SELDRV      EQU 14           
F_SFIRST      EQU 17          
F_SNEXT       EQU 18          
FCB           EQU $005C        
TBUFF         EQU $0080        

; --- NABU Hardware Constants ---
AY_REG_SEL    EQU $41
AY_DATA_WR    EQU $40

; *****************************************************************************
; * ENTRY POINT
; *****************************************************************************
start:
    ld hl, ($0006)
    ld de, -$0400
    add hl, de
    ld sp, hl           

    ; --- Automatic Terminal Detection via Memory Address 0x0003 ---
    ld a, ($0003)
    ld b, 0             ; Default to ADM-3a (0)
    cp $01 : jr z, .is_vt
    cp $93 : jr z, .is_vt
    cp $94 : jr z, .is_vt
    cp $9B : jr z, .is_vt
    jr .save_term
.is_vt:
    inc b               ; Set to VT100 (1)
.save_term:
    ld a, b
    ld (term_mode), a

    ; --- Initial Screen Clear (VT100 vs ADM-3a) ---
    ld a, (term_mode)
    or a : jr z, .adm_clr
    ld de, msg_vt_cls : ld c, F_PRTSTR : call BDOS
    jr .init_sys
.adm_clr:
    ld e, 26 : ld c, F_CONOUT : call BDOS

.init_sys:
    ld e, $FF : ld c, F_USER : call BDOS : ld (orig_user), a
    ld c, F_CURDRV : call BDOS : ld (orig_drive), a

    call smart_parse

    ld de, msg_start : ld c, F_PRTSTR : call BDOS
    call draw_ui_legend

find_initial:
    jp .jukebox_mode    

.jukebox_mode:
    ld de, TBUFF : ld c, F_SETDMA : call BDOS
    ld hl, jukebox_wildcard : ld de, FCB+1 : ld bc, 11 : ldir
    ld de, FCB : ld c, F_SFIRST : call BDOS
    inc a : jp z, no_files_error
    dec a : call store_found_as_current
    jp play_current

; *****************************************************************************
; * MAIN ENGINE
; *****************************************************************************
vgm_main:
    ld hl, (vgm_ptr)
    ld de, (vgm_end_ptr)
    and a : sbc hl, de
    jp nc, refill_needed      
play_next_byte:
    ld hl, (vgm_ptr)
    ld a, (hl) : inc hl : ld (vgm_ptr), hl
    cp $A0 : jp z, do_ay      
    cp $62 : jp z, do_wait    
    cp $61 : jp z, do_wait_n  
    cp $66 : jp z, auto_advance 
    
    ld e, $FF : ld c, F_DIRIO : call BDOS
    or a : jr z, vgm_main
    and $7F
    cp 'q' : jp z, exit_all
    cp 'p' : call z, pause_now
    cp '>' : jp z, skip_next     
    cp '.' : jp z, skip_next     
    cp '<' : jp z, skip_prev     
    cp ',' : jp z, skip_prev     
    cp 'l' : call z, toggle_loop
    cp '+' : call z, speed_faster
    cp '=' : call z, speed_faster
    cp '-' : call z, speed_slower
    jr vgm_main               

do_ay:
    ld hl, (vgm_ptr)
    ld c, (hl) : inc hl
    ld b, (hl) : inc hl
    ld (vgm_ptr), hl
    push hl
    ld hl, ay_shadow
    ld e, c : ld d, 0 : add hl, de
    ld (hl), b
    pop hl
    ld a, c : cp 7 : jr nz, .o 
    ld a, b : and %00111111 : or %01000000 : ld b, a
.o: ld a, c : out (AY_REG_SEL), a
    ld a, b : out (AY_DATA_WR), a 
    jp vgm_main                

do_wait:
    ld hl, (wait_count) : inc hl : ld (wait_count), hl
    ld de, 60 : and a : sbc hl, de : jr nz, .n
    ld hl, 0 : ld (wait_count), hl
    ld a, (time_sec) : inc a : cp 60 : jr nz, .nm
    xor a : ld hl, (time_min) : inc hl : ld (time_min), hl
.nm: ld (time_sec), a : call update_ui_time
.n: ld a, (speed_val) : or a : jp z, vgm_main 
    ld b, a
.outr: push bc : ld de, $0250
.innr: dec de : ld a, d : or e : jr nz, .innr : pop bc : djnz .outr 
    jp vgm_main                

do_wait_n: 
    ld hl, (vgm_ptr) : inc hl : inc hl : ld (vgm_ptr), hl 
    jp do_wait

refill_needed:
    call silence_ay
    ld a, 14 : call set_cursor : ld de, msg_refill : ld c, F_PRTSTR : call BDOS
    ld hl, (cur_part) : inc hl : ld (cur_part), hl : call update_ui_parts
    call refill_buffer
    ld a, 14 : call set_cursor : ld de, msg_blank : ld c, F_PRTSTR : call BDOS 
    call restore_ay
    jp vgm_main

auto_advance:
    ld a, (loop_flag) : or a : jr nz, do_loop
    jp skip_next

do_loop:
    call silence_ay : xor a : ld (FCB + 12), a : ld (FCB + 32), a
    ld hl, 1 : ld (cur_part), hl : ld hl, 0 : ld (time_min), hl
    ld (time_sec), a : ld (wait_count), hl
    ld de, FCB : ld c, F_OPEN : call BDOS
    xor a : ld (first_load), a
    call refill_buffer
    call update_ui_parts : call update_ui_time : call restore_ay
    jp vgm_main

; *****************************************************************************
; * TERMINAL & UI HELPERS
; *****************************************************************************
set_cursor:
    push af
    ld a, (term_mode) : or a : jr nz, .vt100
.adm3a:
    ld e, 27 : ld c, F_CONOUT : call BDOS : ld e, '=' : ld c, F_CONOUT : call BDOS
    pop af : push af : add a, 32 + 2 : ld e, a : ld c, F_CONOUT : call BDOS 
    ld e, 32 : ld c, F_CONOUT : call BDOS
    pop af : ret
.vt100:
    ld e, 27 : ld c, F_CONOUT : call BDOS : ld e, '[' : ld c, F_CONOUT : call BDOS
    pop af : push af : add a, 3 : ld l, a : ld h, 0 : call prt_num_16
    ld de, msg_vt_suffix : ld c, F_PRTSTR : call BDOS
    pop af : ret

update_ui_file: ld a, 0 : call set_cursor : ld de, msg_playing : ld c, F_PRTSTR : call BDOS : call print_filename : ret
update_ui_speed: ld a, 1 : call set_cursor : ld de, msg_speed_lbl : ld c, F_PRTSTR : call BDOS
    ld a, (speed_val) : ld l, a : ld h, 0 : call prt_num_16 : ld de, msg_blank_sm : ld c, F_PRTSTR : call BDOS : ret
update_ui_loop: ld a, 2 : call set_cursor : ld de, msg_loop_lbl : ld c, F_PRTSTR : call BDOS
    ld a, (loop_flag) : or a : ld de, msg_lon : jr nz, .p : ld de, msg_loff
.p: ld c, F_PRTSTR : call BDOS : ret
update_ui_parts: ld a, 3 : call set_cursor : ld de, msg_part_lbl : ld c, F_PRTSTR : call BDOS
    ld hl, (cur_part) : call prt_num_16 : ld de, msg_of : ld c, F_PRTSTR : call BDOS
    ld hl, (total_parts) : call prt_num_16 : ret
update_ui_time: ld a, 4 : call set_cursor : ld de, msg_time_lbl : ld c, F_PRTSTR : call BDOS
    ld hl, (time_min) : call prt_num_16 : ld e, ':' : ld c, F_CONOUT : call BDOS
    ld a, (time_sec) : cp 10 : jr nc, .s : ld e, '0' : ld c, F_CONOUT : call BDOS
.s: ld l, a : ld h, 0 : call prt_num_16 : ret

draw_ui_legend:
    ld a, 6 : call set_cursor : ld de, msg_legend : ld c, F_PRTSTR : call BDOS : ret

pause_now:
    call silence_ay
    ld a, 16 : call set_cursor : ld de, msg_pause : ld c, F_PRTSTR : call BDOS
.w: ld e, $FF : ld c, F_DIRIO : call BDOS : or a : jr z, .w
    ld a, 16 : call set_cursor : ld de, msg_blank : ld c, F_PRTSTR : call BDOS
    call restore_ay : ret

; *****************************************************************************
; * JUKEBOX NAVIGATION & FILE IO
; *****************************************************************************
skip_next: call prepare_next : jp play_current
skip_prev: call prepare_prev : jp play_current

play_current:
    call copy_current_to_fcb
    ld de, FCB : ld c, F_OPEN : call BDOS
    inc a : jp z, open_error_logic
    call init_shadow : call silence_ay : call calculate_total_parts
    call update_ui_file : call update_ui_speed : call update_ui_loop
    call update_ui_parts : call update_ui_time
    xor a : ld (first_load), a : ld (time_sec), a 
    ld hl, 0 : ld (time_min), hl : ld (wait_count), hl
    call refill_buffer
    jp vgm_main

prepare_next:
    call silence_ay : ld de, TBUFF : ld c, F_SETDMA : call BDOS
    call clear_temp_fcb : ld hl, jukebox_wildcard : ld de, FCB_TEMP+1 : ld bc, 11 : ldir
    ld de, FCB_TEMP : ld c, F_SFIRST : call BDOS
.search: inc a : jr z, .wrap : dec a : call check_if_current : jr z, .found
    ld de, FCB_TEMP : ld c, F_SNEXT : call BDOS : jr .search
.found: ld de, FCB_TEMP : ld c, F_SNEXT : call BDOS : inc a : jr z, .wrap : dec a : call store_found_as_current : ret
.wrap: ld de, FCB_TEMP : ld c, F_SFIRST : call BDOS : inc a : jp z, no_files_error : dec a : call store_found_as_current : ret

prepare_prev:
    call silence_ay : ld de, TBUFF : ld c, F_SETDMA : call BDOS
    call clear_temp_fcb : ld hl, jukebox_wildcard : ld de, FCB_TEMP+1 : ld bc, 11 : ldir
    xor a : ld (found_prev_flag), a : ld de, FCB_TEMP : ld c, F_SFIRST : call BDOS
.prev_loop: inc a : jr z, .wrap_logic : dec a : push af : call check_if_current : jr z, .found_current
    pop af : call store_found_as_prev : ld a, 1 : ld (found_prev_flag), a
    ld de, FCB_TEMP : ld c, F_SNEXT : call BDOS : jr .prev_loop
.found_current: pop af : ld a, (found_prev_flag) : or a : jr z, .wrap_logic : jr .done_prev                
.wrap_logic: call clear_temp_fcb : ld hl, jukebox_wildcard : ld de, FCB_TEMP+1 : ld bc, 11 : ldir
    ld de, FCB_TEMP : ld c, F_SFIRST : call BDOS
.last_loop: inc a : jr z, .done_prev : dec a : call store_found_as_prev : ld de, FCB_TEMP : ld c, F_SNEXT : call BDOS : jr .last_loop
.done_prev: ld hl, last_seen_file : ld de, current_file : ld bc, 11 : ldir : ret

store_found_as_current:
    add a : add a : add a : add a : add a : ld hl, TBUFF : ld e, a : ld d, 0 : add hl, de : inc hl : ld de, current_file : ld bc, 11 : ldir : ret
store_found_as_prev:
    add a : add a : add a : add a : add a : ld hl, TBUFF : ld e, a : ld d, 0 : add hl, de : inc hl : ld de, last_seen_file : ld bc, 11 : ldir : ret
check_if_current:
    add a : add a : add a : add a : add a : ld hl, TBUFF : ld e, a : ld d, 0 : add hl, de : inc hl : ld de, current_file : ld b, 11
.lp: ld a, (de) : cp (hl) : ret nz : inc hl : inc de : djnz .lp : xor a : ret
copy_current_to_fcb:
    ld hl, current_file : ld de, FCB+1 : ld bc, 11 : ldir : xor a : ld (FCB+12), a : ld (FCB+32), a : ret
clear_temp_fcb:
    ld hl, FCB_TEMP : ld (hl), 0 : inc hl : ld b, 11
.c1: ld (hl), ' ' : inc hl : djnz .c1 : ld b, 20
.c2: ld (hl), 0 : inc hl : djnz .c2 : ret

; *****************************************************************************
; * PARSER & MISC HELPERS
; *****************************************************************************
smart_parse:
    ld hl, TBUFF : ld a, (hl) : or a : ret z : ld b, a : inc hl
.skip_space: ld a, (hl) : cp ' ' : jr nz, .check_arg : inc hl : djnz .skip_space : ret
.check_arg: ld a, (hl) : and $5F : sub 'A' : cp 16 : jp nc, .try_filename_only
    inc hl : ld a, (hl) : dec hl : cp ' ' : jp z, .is_drive : cp 0 : jp z, .is_drive : cp ':' : jp z, .is_drive : jp .try_filename_only                                             
.is_drive: ld a, (hl) : and $5F : sub 'A' : ld e, a : push hl : push bc : ld c, F_SELDRV : call BDOS : pop bc : pop hl : inc hl : dec b : jp z, .done        
.skip_to_user: ld a, (hl) : cp ' ' : jr nz, .check_user : inc hl : djnz .skip_to_user : jp .done 
.check_user: ld a, (hl) : call char_to_hex : cp 16 : jp nc, .manual_file_extract : ld e, a : push hl : push bc : ld c, F_USER : call BDOS : pop bc : pop hl
    inc hl : dec b : jp z, .done        
.skip_to_filename: ld a, (hl) : cp ' ' : jr nz, .manual_file_extract : inc hl : djnz .skip_to_filename : jp .done 
.try_filename_only: ld a, (FCB+1) : cp ' ' : ret z : ld hl, FCB+1 : ld de, current_file : ld bc, 11 : ldir : jp .force_play                      
.manual_file_extract: push hl : ld hl, current_file : ld b, 11 : ld a, ' '
.clr: ld (hl), a : inc hl : djnz .clr : pop hl : ld de, current_file : ld b, 8
.fn_loop: ld a, (hl) : cp '.' : jr z, .find_ext : cp ' ' : jr z, .done_manual : cp 0 : jr z, .done_manual : ld (de), a : inc hl : inc de : djnz .fn_loop
.skip_to_dot: ld a, (hl) : cp '.' : jr z, .find_ext : cp ' ' : jr z, .done_manual : cp 0 : jr z, .done_manual : inc hl : jr .skip_to_dot
.find_ext: inc hl : ld de, current_file + 8 : ld b, 3
.ext_loop: ld a, (hl) : cp ' ' : jr z, .done_manual : cp 0 : jr z, .done_manual : ld (de), a : inc hl : inc de : djnz .ext_loop
.done_manual: ld hl, current_file : ld b, 11
.up: ld a, (hl) : cp 'a' : jr c, .nu : cp '{' : jr nc, .nu : sub 32 : ld (hl), a
.nu: inc hl : djnz .up
.force_play: ld hl, play_current : ld (find_initial + 1), hl 
.done: ret

char_to_hex: cp 'a' : jr c, .nh : sub 32
.nh: sub '0' : cp 10 : ret c : sub 7 : ret

init_shadow: ld hl, ay_shadow : ld b, 14 : xor a
.lp: ld (hl), a : inc hl : djnz .lp : ld a, %01111000 : ld (ay_shadow + 7), a : ret

silence_ay: ld a, 8 : out (AY_REG_SEL), a : xor a : out (AY_DATA_WR), a
    ld a, 9 : out (AY_REG_SEL), a : xor a : out (AY_DATA_WR), a
    ld a, 10 : out (AY_REG_SEL), a : xor a : out (AY_DATA_WR), a : ret

restore_ay: ld b, 0
.lp: ld a, b : out (AY_REG_SEL), a : push bc : ld hl, ay_shadow : ld e, b : ld d, 0 : add hl, de : ld a, (hl) : ld c, a : ld a, b : cp 7 : jr nz, .o
    ld a, c : and %00111111 : or %01000000 : ld c, a
.o: ld a, c : out (AY_DATA_WR), a : pop bc : inc b : ld a, b : cp 11 : jr nz, .lp : ret

refill_buffer:
    ld hl, buffer_zone : ld (vgm_ptr), hl : ld bc, (records_per_chunk)
.rl: push bc : push hl : ld d, h : ld e, l : ld c, F_SETDMA : call BDOS : ld de, FCB : ld c, F_READ : call BDOS : pop hl : pop bc
    or a : jr nz, .eof : ld de, 128 : add hl, de : dec bc : ld a, b : or c : jr nz, .rl
.eof: ld (vgm_end_ptr), hl : ld a, (first_load) : or a : ret nz
    ld hl, buffer_zone + $34 : ld e, (hl) : inc hl : ld d, (hl) : ld a, d : or e : jr nz, .offs : ld de, $40 - $34
.offs: ld hl, buffer_zone + $34 : add hl, de : ld (vgm_ptr), hl : ld (vgm_restart), hl : ld a, 1 : ld (first_load), a : ret

prt_num_16:
    ld de, -10000 : call .dig : ld de, -1000 : call .dig : ld de, -100 : call .dig : ld de, -10 : call .dig : ld de, -1
.dig: ld a, '0' - 1
.lp: inc a : add hl, de : jr c, .lp : sbc hl, de : cp '0' : jr nz, .out : ld c, a : ld a, e : cp -1 : ld a, c : jr z, .out : ret                                     
.out: ld e, a : push hl : push de : ld c, F_CONOUT : call BDOS : pop de : pop hl : ret

toggle_loop: ld a, (loop_flag) : xor 1 : ld (loop_flag), a : call update_ui_loop : ret
speed_faster: ld a, (speed_val) : or a : ret z : dec a : ld (speed_val), a : call update_ui_speed : ret
speed_slower: ld a, (speed_val) : cp 60 : ret z : inc a : ld (speed_val), a : call update_ui_speed : ret

calculate_total_parts:
    ld de, FCB : ld c, F_SIZE : call BDOS : ld hl, (FCB + 33) : ld a, h : or l : jr nz, .ok : inc hl
.ok: ld (temp_total), hl : ld de, (records_per_chunk) : ld bc, 0            
.lp: inc bc : and a : sbc hl, de : jr z, .dn : jr nc, .lp    
.dn: ld (total_parts), bc : ld hl, 1 : ld (cur_part), hl : ret

print_filename:
    ld hl, FCB + 1 : ld b, 8
.n: ld a, (hl) : cp ' ' : jr z, .ex_pad : ld e, a : push bc : push hl : ld c, F_CONOUT : call BDOS : pop hl : pop bc : inc hl : djnz .n : jr .dot
.ex_pad: ld a, b : or a : jr z, .dot
.p1: ld e, ' ' : push bc : ld c, F_CONOUT : call BDOS : pop bc : djnz .p1
.dot: ld e, '.' : ld c, F_CONOUT : call BDOS : ld hl, FCB + 9 : ld b, 3
.e: ld a, (hl) : cp ' ' : jr z, .e_pad : ld e, a : push bc : push hl : ld c, F_CONOUT : call BDOS : pop hl : pop bc : inc hl : djnz .e : ret
.e_pad: ld a, b : or a : ret z
.p2: ld e, ' ' : push bc : ld c, F_CONOUT : call BDOS : pop bc : djnz .p2 : ret

no_files_error: ld de, msg_no_vgm : ld c, F_PRTSTR : call BDOS : jp exit_all
open_error_logic: ld de, msg_no_file : ld c, F_PRTSTR : call BDOS : jp exit_all

exit_all:
    call silence_ay : ld a, 7 : out (AY_REG_SEL), a : ld a, %01111111 : out (AY_DATA_WR), a
    ld a, 20 : call set_cursor : ld a, (orig_user) : ld e, a : ld c, F_USER : call BDOS
    ld a, (orig_drive) : ld e, a : ld c, F_SELDRV : call BDOS : ld c, 0 : call BDOS

; *****************************************************************************
; * DATA SECTION
; *****************************************************************************
term_mode:         db 0
jukebox_wildcard:  db "????????VGM"
current_file:      ds 12
last_seen_file:    ds 12
found_prev_flag:   db 0
FCB_TEMP:          ds 36
msg_start:         db "NABU PC VGM Player v0.3 by GTAMP", 13, 10, "$"
msg_playing:       db "File:  ", "$"
msg_speed_lbl:     db "Delay: ", "$"
msg_loop_lbl:      db "Loop:  ", "$"
msg_part_lbl:      db "Chunk: ", "$"
msg_time_lbl:      db "Time:  ", "$"
msg_of:            db " of ", "$"
msg_refill:        db "[ BUFFERING... ]", "$"
msg_blank:         db "                ", "$"
msg_blank_sm:      db "  ", "$"
msg_no_vgm:        db 13, 10, "Error: No .VGM files found!", 13, 10, "$"
msg_no_file:       db 13, 10, "Error: File not found", 13, 10, "$"
msg_pause:         db "[ PAUSED       ]", "$"
msg_lon:           db "YES", "$"
msg_loff:          db "NO ", "$"
msg_legend:
    db "----------------------------", 13, 10
    db " [>] Next     [<] Prev", 13, 10
    db " [P] Pause    [L] Loop", 13, 10
    db " [+/-] Speed  [Q] Quit", 13, 10
    db "----------------------------", "$"
msg_vt_cls:        db 27, "[2J", 27, "[H", "$"
msg_vt_suffix:     db ";1H", "$"

orig_user:         db 0
orig_drive:        db 0
speed_val:         db 3
loop_flag:         db 0
first_load:        db 0
time_sec:          db 0
time_min:          dw 0
wait_count:        dw 0
cur_part:          dw 1
total_parts:       dw 1
records_per_chunk: dw 320
temp_total:        dw 0
vgm_ptr:           dw 0
vgm_restart:       dw 0
vgm_end_ptr:       dw 0
ay_shadow:         ds 16      
    ALIGN 256
buffer_zone: